<?php
/*
    This file is part of prusa2thingshare, a bridge between Thingshare and Prusaprinters.org
    Copyright (C) 2020  Alicia <alicia@ion.nu>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
function getcache($name)
{
  $hash=hash('sha256', $name);
  if(!file_exists('cache/'.$hash)){return false;}
  return file_get_contents('cache/'.$hash);
}

function savecache($name, $content)
{
  $hash=hash('sha256', $name);
  if(!file_exists('cache')){mkdir('cache',0755);}
  file_put_contents('cache/'.$hash, $content);
}
?>
