<?php
/*
    This file is part of prusa2thingshare, a bridge between Thingshare and Prusaprinters.org
    Copyright (C) 2020  Alicia <alicia@ion.nu>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
include_once('cache.php');
$id=$path[3];
$cachename='comments/'.$id;
if(!($response=getcache($cachename)))
{
  $curl=curl_init('https://www.prusaprinters.org/graphql/');
  curl_setopt($curl, CURLOPT_HTTPHEADER, Array('Content-Type: application/json'));
  curl_setopt($curl, CURLOPT_POST, true);
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($curl, CURLOPT_POSTFIELDS, '{"operationName":"PrintComments","variables":{"id":"'.$id.'","offset":0,"limit":10,"ordering":{"orderBy":"newest_parent","sortOrder":"descending"},"onlyMeInvolved":false},"query":"query PrintComments($id: ID!, $ordering: CommentsOrderingObject, $onlyMeInvolved: Boolean, $search: String, $limit: Int, $offset: Int) {\n  print(id: $id) {\n    id\n    images {\n      id\n      filePath\n      __typename\n    }\n    canBeRated\n    __typename\n  }\n  commentsCount: print(id: $id) {\n    id\n    commentCount\n    __typename\n  }\n  comments: printComments(printId: $id, ordering: $ordering, onlyMeInvolved: $onlyMeInvolved, search: $search, limit: $limit, offset: $offset) {\n    ...PrintCommentsFragment\n    replies {\n      ...PrintCommentsFragment\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment PrintCommentsFragment on PrintCommentType {\n  id\n  created\n  edited\n  deleted\n  parent {\n    id\n    __typename\n  }\n  author {\n    id\n    slug\n    avatarFilePath\n    publicUsername\n    __typename\n  }\n  images {\n    id\n    filePath\n    __typename\n  }\n  mentions {\n    id\n    publicUsername\n    __typename\n  }\n  text\n  printRating {\n    rating\n    __typename\n  }\n  authorPublicUsername\n  involvedUsers {\n    id\n    slug\n    avatarFilePath\n    publicUsername\n    __typename\n  }\n  __typename\n}\n"}');
  $res=curl_exec($curl);
  $res=json_decode($res, true);
  $comments=Array();
  $replies=Array();
  foreach($res['data']['comments'] as $comment)
  {
    $c=Array(
      'id'=>$comment['id'],
      'sender'=>$comment['author']['id'].'@'.$_SERVER['HTTP_HOST'],
      'replyto'=>($comment['parent']?$comment['parent']:0),
      'message'=>$comment['text'],
      'sent'=>$comment['created'],
      'removed'=>($comment['deleted']?true:false)
    );
    // Add images as links
    if(count($comment['images'])>0)
    {
      $c['message'].="\n";
      $i=1;
      foreach($comment['images'] as $img)
      {
        $c['message'].="\n[Image ".($i++).'](https://media.prusaprinters.org/'.$img['filePath'].')  ';
      }
    }
    if($c['replyto'])
    {
      $replies[]=$c;
    }else{
      $comments[]=$c;
    }
  }
  function resolvereplies($id)
  {
    global $replies;
    $r=Array();
    foreach($replies as $i)
    { 
      if($i['replyto']==$id)
      { 
        $i['replies']=resolvereplies($i['id']);
        $r[]=$i;
      }
    }
    return $r;
  }
  foreach($comments as $i=>$c){$comments[$i]['replies']=resolvereplies($comments[$i]['id']);}
  $response=json_encode($comments);
  savecache($cachename, $response);
}
print($response);
?>
