<?php
/*
    This file is part of prusa2thingshare, a bridge between Thingshare and Prusaprinters.org
    Copyright (C) 2020  Alicia <alicia@ion.nu>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
include_once('cache.php');
$query=$path[3];
// TODO: If $query=='' grab results from the front page instead?
$sort=$path[4];
if($sort=='new'){$sort='"latest"';}
else{$sort='null';} // Default to "best match"
$count=(int)$path[5];
$offset=(int)$path[6];
$cachename='search/'.$query.'/'.$sort.'/'.$count.'/'.$offset;
if(!($response=getcache($cachename)))
{
$curl=curl_init('https://www.prusaprinters.org/graphql/');
curl_setopt($curl, CURLOPT_HTTPHEADER, Array('Content-Type: application/json'));
curl_setopt($curl, CURLOPT_POST, true);
curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
curl_setopt($curl, CURLOPT_POSTFIELDS, '{"operationName":"SearchPrints","variables":{"query":"'.$query.'","ordering":'.$sort.',"limit":'.$count.',"offset":'.$offset.'},"query":"query SearchPrints($query: String, $limit: Int, $offset: Int, $ordering: SearchChoicesEnum) {\n  searchPrints(query: $query, limit: $limit, offset: $offset, ordering: $ordering) {\n    totalCount\n    items {\n      ...SearchPrintsFragment\n      __typename\n    }\n    __typename\n  }\n  searchUsers(query: $query, limit: 0) {\n    totalCount\n    __typename\n  }\n  searchCategories(query: $query, limit: 0) {\n    totalCount\n    __typename\n  }\n  searchCollections(query: $query, limit: 0) {\n    totalCount\n    __typename\n  }\n}\n\nfragment SearchPrintsFragment on SearchPrintType {\n  id\n  score\n  explanation\n  mainImage\n  ratingAvg\n  ratingCount\n  filesType\n  hasModel\n  name\n  downloadCount\n  displayCount\n  dateFeatured\n  datePublished\n  slug\n  liked\n  likesCount\n  user {\n    id\n    slug\n    publicUsername\n    avatarFilePath\n    __typename\n  }\n  __typename\n}\n"}');
$res=curl_exec($curl);

$res=json_decode($res, true);
$things=Array();
foreach($res['data']['searchPrints']['items'] as $thing)
{
  $things[]=Array(
    'id'=>$thing['id'],
    'name'=>$thing['name'],
    'destription'=>'',
    'date'=>$thing['datePublished'],
// TODO: Cache and mirror mainImage? Kind of too high-res for thumbnails
    'preview'=>'https://media.prusaprinters.org/'.$thing['mainImage'],
    'by'=>Array(
      'displayname'=>$thing['user']['publicUsername'],
      'name'=>$thing['user']['id']
    )
  );
}
$response=json_encode($things);
savecache($cachename, $response);
}
print($response);
?>
