<?php
/*
    This file is part of prusa2thingshare, a bridge between Thingshare and Prusaprinters.org
    Copyright (C) 2020  Alicia <alicia@ion.nu>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
include_once('cache.php');
$id=$path[3];
$cachename='thing/'.$id;
if(!($response=getcache($cachename)))
{
  $curl=curl_init('https://www.prusaprinters.org/graphql/');
  curl_setopt($curl, CURLOPT_HTTPHEADER, Array('Content-Type: application/json'));
  curl_setopt($curl, CURLOPT_POST, true);
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($curl, CURLOPT_POSTFIELDS, '{"operationName":"PrintProfile","variables":{"id":"'.$id.'"},"query":"query PrintProfile($id: ID!) {\n  print(id: $id) {\n    id\n    slug\n    name\n    user {\n      id\n      slug\n      email\n      donationLinks {\n        id\n        title\n        url\n        __typename\n      }\n      publicUsername\n      avatarFilePath\n      offersPrintOnDemand\n      __typename\n    }\n    ratingAvg\n    myRating\n    ratingCount\n    content\n    category {\n      id\n      path {\n        id\n        name\n        __typename\n      }\n      __typename\n    }\n    modified\n    firstPublish\n    datePublished\n    hasModel\n    summary\n    shareCount\n    likesCount\n    liked\n    printDuration\n    numPieces\n    weight\n    nozzleDiameters\n    usedMaterial\n    layerHeights\n    materials {\n      name\n      __typename\n    }\n    dateFeatured\n    downloadCount\n    displayCount\n    filesCount\n    collectionsCount\n    pdfFilePath\n    commentCount\n    userGcodeCount\n    userGcodesCount\n    remixCount\n    canBeRated\n    inMyCollections\n    printer {\n      id\n      name\n      __typename\n    }\n    images {\n      id\n      filePath\n      __typename\n    }\n    tags {\n      name\n      id\n      __typename\n    }\n    thingiverseLink\n    filesType\n    foundInUserGcodes\n    remixParents {\n      ...remixParentDetail\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment remixParentDetail on PrintRemixType {\n  id\n  parentPrintName\n  parentPrintAuthor {\n    id\n    slug\n    publicUsername\n    __typename\n  }\n  parentPrint {\n    id\n    name\n    slug\n    datePublished\n    images {\n      id\n      filePath\n      __typename\n    }\n    license {\n      id\n      name\n      disallowRemixing\n      __typename\n    }\n    __typename\n  }\n  __typename\n}\n"}');
  $res=curl_exec($curl);
  curl_setopt($curl, CURLOPT_POSTFIELDS, '{"operationName":"PrintFiles","variables":{"id":"'.$id.'"},"query":"query PrintFiles($id: ID!) {\n  print(id: $id) {\n    id\n    gcodes {\n      id\n      name\n      filePath\n      filePreviewPath\n      created\n      nozzleDiameter\n      printDuration\n      layerHeight\n      material {\n        id\n        name\n        __typename\n      }\n      weight\n      fileSize\n      filePath\n      printer {\n        id\n        name\n        __typename\n      }\n      __typename\n    }\n    stls {\n      id\n      name\n      created\n      fileSize\n      filePath\n      filePreviewPath\n      __typename\n    }\n    slas {\n      id\n      name\n      created\n      fileSize\n      filePath\n      filePreviewPath\n      printDuration\n      layerHeight\n      usedMaterial\n      expTime\n      firstExpTime\n      printer {\n        id\n        name\n        __typename\n      }\n      __typename\n    }\n    downloadPacks {\n      id\n      name\n      fileSize\n      fileType\n      filePath\n      __typename\n    }\n    license {\n      id\n      name\n      content\n      __typename\n    }\n    thingiverseLink\n    filesType\n    __typename\n  }\n}\n"}');
  $res2=curl_exec($curl);

  $res=json_decode($res, true);
  $res2=json_decode($res2, true);
  $thing=Array(
    'id'=>$res['data']['print']['id'],
    'name'=>$res['data']['print']['name'],
    'description'=>'Mirrored from https://www.prusaprinters.org/prints/'.$res['data']['print']['id'].'-'.$res['data']['print']['slug']."\n\n".$res['data']['print']['summary'],
    'date'=>$res['data']['print']['datePublished'],
//    'preview'=>'https://www.prusaprinters.org/'.$res['data']['print']['mainImage'],
    'by'=>Array(
      'displayname'=>$res['data']['print']['user']['publicUsername'],
      'name'=>$res['data']['print']['user']['id']
    )
  );
  $thing['license']=Array(
    'name'=>$res2['data']['print']['license']['name'],
    'simple'=>$res2['data']['print']['license']['content']
  );
  $thing['files']=Array();
  foreach($res2['data']['print']['images'] as $file)
  {
    $thing['files'][]=Array(
      'name'=>basename($file['filePath']),
      'path'=>'https://media.prusaprinters.org/'.$file['filePath'],
      'preview'=>'https://media.prusaprinters.org/'.$file['filePath']
    );
  }
  foreach($res2['data']['print']['stls'] as $file)
  {
    $thing['files'][]=Array(
      'name'=>$file['name'],
      'path'=>'https://media.prusaprinters.org/'.$file['filePath'],
      'preview'=>($file['filePreviewPath']==''?'':'https://media.prusaprinters.org/'.$file['filePreviewPath'])
    );
  }
  $response=json_encode($thing);
  savecache($cachename, $response);
}
print($response);
?>
