<?php
/*
    This file is part of prusa2thingshare, a bridge between Thingshare and Prusaprinters.org
    Copyright (C) 2020  Alicia <alicia@ion.nu>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/
include_once('cache.php');
$id=$path[3];
$cachename='user/'.$id;
if(!($response=getcache($cachename)))
{
  $curl=curl_init('https://www.prusaprinters.org/graphql/');
  curl_setopt($curl, CURLOPT_HTTPHEADER, Array('Content-Type: application/json'));
  curl_setopt($curl, CURLOPT_POST, true);
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($curl, CURLOPT_POSTFIELDS, '{"operationName":"UserProfileSocialPrints","variables":{"id":"'.$id.'","limit":60,"offset":0,"printerIds":null,"materialIds":null,"hasModel":null,"ordering":null,"nozzleDiameters":null},"query":"query UserProfileSocialPrints($id: ID!, $limit: Int!, $offset: Int, $materialIds: [Int], $printerIds: [Int], $ordering: String, $hasModel: Boolean, $filesType: [FilterPrintFilesTypeEnum], $nozzleDiameters: [Float]) {\n  prints(userId: $id, limit: $limit, offset: $offset, materialIds: $materialIds, printerIds: $printerIds, nozzleDiameters: $nozzleDiameters, ordering: $ordering, hasModel: $hasModel, filesType: $filesType) {\n    ...PrintListFragment\n    __typename\n  }\n}\n\nfragment PrintListFragment on PrintType {\n  id\n  name\n  slug\n  ratingAvg\n  ratingCount\n  likesCount\n  liked\n  datePublished\n  dateFeatured\n  downloadCount\n  displayCount\n  inMyCollections\n  foundInUserGcodes\n  userGcodeCount\n  userGcodesCount\n  materials {\n    id\n    __typename\n  }\n  category {\n    id\n    path {\n      id\n      name\n      __typename\n    }\n    __typename\n  }\n  modified\n  images {\n    id\n    filePath\n    __typename\n  }\n  filesType\n  hasModel\n  user {\n    id\n    slug\n    avatarFilePath\n    publicUsername\n    __typename\n  }\n  __typename\n}\n"}');
  $res=curl_exec($curl);

  $res=json_decode($res, true);
  $user=Array('things'=>Array());
  foreach($res['data']['prints'] as $thing)
  {
    $user['things'][]=Array(
      'id'=>$thing['id'],
      'name'=>$thing['name'],
      'description'=>'',
      'date'=>$thing['datePublished'],
      'preview'=>($thing['images'][0]['filePath']==''?'':'https://www.prusaprinters.org/'.$thing['images'][0]['filePath'])
    );
    $user['displayname']=$thing['user']['publicUsername'];
    $user['profile']='Mirrored from https://www.prusaprinters.org/social/'.$thing['user']['id'].'-'.$thing['user']['slug'].'/prints';
  }
  if(count($user['things'])==0) // Fall back to plain user page, maybe also do this regardless to get the donation links
  {
    curl_setopt($curl, CURLOPT_POSTFIELDS, '{"operationName":"UserProfileSocial","variables":{"id":"'.$id.'"},"query":"query UserProfileSocial($id: ID!) {\n  user(id: $id) {\n    id\n    hashId\n    slug\n    publicUsername\n    email\n    place\n    avatarFilePath\n    offersPrintOnDemand\n    offersTechSupport\n    offersShowAndTell\n    isFollowedByMe\n    downloadCount\n    printsCount\n    userGcodesCount\n    followersCount\n    followingCount\n    collectionsCount\n    eventsCount\n    rating\n    isPublicSpace\n    coordinates {\n      lat\n      lng\n      __typename\n    }\n    locationSharing\n    bio\n    donationLinks {\n      id\n      title\n      url\n      __typename\n    }\n    printers {\n      id\n      name\n      __typename\n    }\n    languages {\n      id\n      name\n      __typename\n    }\n    __typename\n  }\n}\n"}');
    $res=curl_exec($curl);
    $res=json_decode($res, true);
    $user['displayname']=$res['data']['user']['publicUsername'];
    $user['profile']='Mirrored from https://www.prusaprinters.org/social/'.$res['data']['user']['id'].'-'.$res['data']['user']['slug'].'/prints';
    if(count($res['data']['user']['printers'])>0)
    {
      $user['profile'].="\n\nPrinters: ";
      $first=true;
      foreach($res['data']['user']['printers'] as $printer)
      {
        $user['profile'].=($first?'':', ').$printer['name'];
        $first=false;
      }
    }
  }
  $response=json_encode($user);
  savecache($cachename, $response);
}
print($response);
?>
